# Usage:
# python deMultiplexer.py path_to_folder_with_fastq key.dat
#
# The program assumes your undetermined files are named according to Illumina convention. BE CAREFUL
# The program also assumes all your indexes are the same length. BE CAREFUL

import sys

baseDir = sys.argv[1]

readFile1 = baseDir + 'Undetermined_S0_L001_R1_001.fastq'
indexFile1 = baseDir + 'Undetermined_S0_L001_I1_001.fastq'

indexlength=0
indexSeq = {}
key = open(sys.argv[2],mode='rU')
for line in key:
    outname = line.strip().split()[0]
    outindex = line.strip().split()[1]
    indexlength = len(outindex)
    indexSeq[outindex] = open(baseDir+outname+'.fastq','w')  
    
with open(readFile1,'rU') as R1File, open(indexFile1,'rU') as I1File:
    counter=0
    R1StringWrite=''
    i1Index=''
    
    for eachIndex1 in I1File:                
        eachRead1 = R1File.next()
        
        if counter==4:
            if i1Index[0:indexlength] in indexSeq:
                indexSeq[i1Index[0:indexlength]].write(R1StringWrite)
                
            counter=0
            R1StringWrite=''            
            i1Index=''
            
        if counter==1:
            i1Index=eachIndex1.strip()
                        
        R1StringWrite+=eachRead1            
        counter+=1
        
    if i1Index[0:indexlength] in indexSeq:
        indexSeq[i1Index[0:indexlength]].write(R1StringWrite)
